﻿
import Constellation
import time
import sys
from xml.dom import minidom
from volet import Volet

def CheckVolet(volet):
    try:
        nouveauStatut = volet.GetStatut()
        if nouveauStatut is not None:
            if nouveauStatut <> volet.etat:
                volet.etat = nouveauStatut
                return volet.ToString()
    except:
        Constellation.WriteInfo("Error getting status of shutter : " + volet.ToString())


def ComplexMessageCallback(data):
    Constellation.WriteInfo(data["A"])
    Constellation.WriteInfo(type(data["A"]))
    Constellation.WriteInfo(type(data["B"]))
    Constellation.WriteInfo(data["C"])

def ActionVoletMessageCallback(data):
    # Action à envoyer à un volet.
    
    try:

        voletStr = data["shutterName"].lower()
        actionStr = data["actionShutter"].lower()

        for s in shutterList:
            if s.nom.lower() == voletStr:
                if actionStr == "montee":
                    s.Open()
                elif actionStr == "descente":
                    s.Close()
                else:
                    s.Stop()
    except:
        Constellation.WriteInfo("Error ActionVoletMessageCallback : " + sys.exc_info()[0])

def OnExit():
    pass  

def OnStart():
    # Register callback sur exit.
    Constellation.OnExitCallback = OnExit

    # Register MessageCallback.
    Constellation.RegisterMessageCallback("ActionVoletMessageCallback", ActionVoletMessageCallback, True, 'ActionVoletMessageCallback with object parameter containing shutter and action properties')
    Constellation.RegisterMessageCallback("ComplexMessageCallback", ComplexMessageCallback, True, 'ComplexMessageCallback with object parameter containing A, B & C properties')
    
    global SHOW_DEBUG
    global shutterList

    Constellation.WriteInfo("Starting ....")    

    # Chargement config.
    if Constellation.GetSetting("ShowDebug") is not None:
        SHOW_DEBUG =  str(Constellation.GetSetting("ShowDebug")).lower() == "true"
    else:
        SHOW_DEBUG = False

    if SHOW_DEBUG:
        Constellation.WriteWarn("Debug mode active.")    

    # Recuperation config et parsing XML...
    xmldoc = minidom.parseString(str(Constellation.GetSetting("Shutters")))
    shutterListXml = xmldoc.getElementsByTagName('shutter')
    Constellation.WriteInfo(str(len(shutterListXml)) + " shutters to load from parameters...")
    time.sleep(1)

    # Tableau des volets.
    shutterList = []

    for s in shutterListXml:
        
        if SHOW_DEBUG:
            Constellation.WriteInfo("Loading " + s.attributes['name'].value)

        # Parcours XML.
        shutterName = str(s.attributes['name'].value)
        shutterEnabled = str(s.attributes['enabled'].value).lower() == "true"
        shutterAddress = ""
        shutterNumber = ""
        shutterInvertedStatus = False
        shutterInvertedCommand = False

        # Parcours des clefs enfants
        for child in s.childNodes:
            if child.nodeName.lower() == "address":
                shutterAddress = str(child.attributes['value'].value)
                shutterNumber = str(child.attributes['number'].value)

            if child.nodeName.lower() == "inverted":
                shutterInvertedStatus = str(child.attributes['status'].value).lower() == "true"
                shutterInvertedCommand = str(child.attributes['command'].value).lower() == "true"
        
        error = False        
        if shutterAddress == "":
            Constellation.WriteError("XML error : shutterAddress not found for shutter " + shutterName + ".")
            error = True
        if shutterNumber == "":
            Constellation.WriteError("XML error : shutterNumber not found for shutter " + shutterName + ".")
            error = True
            
        if error == False:
            volet = Volet(shutterName, shutterAddress, int(shutterNumber), shutterInvertedStatus, shutterInvertedCommand)
            
            if SHOW_DEBUG:
                # Tempo avant debug.
                time.sleep(0.1)
                Constellation.WriteInfo(volet.ToString())
            
            # Ajout dans la liste des volets seulement si actif.
            if shutterEnabled == True:
                shutterList.append(volet)
        else:
            return
        
        time.sleep(0.1)
        
    Constellation.WriteInfo(str(len(shutterList)) + " active shutters loaded, initialization end.")
    Constellation.WriteInfo("---------------------------------------------")
    
    try:

        while Constellation.IsRunning:
            time.sleep(0.1)
            # Ecoute des modifications sur l etat des volets...
            for volet in shutterList:
                ret = None
                ret = CheckVolet(volet)

                #if volet.adresse == "0x11":
                #    volet.etat = volet.GetStatut()
                #    Constellation.WriteInfo(volet.GetStatut2())
                #    time.sleep(1)

                if ret is not None:
                
                    # Changement, on met a jour le stateobject.
                    Constellation.PushStateObject(volet.nom,  volet.etat, "Shutter", { "Adresse": volet.adresse, "Numero": volet.numero, "Statut inversé" : volet.inverseStatut, "Commande inversée" : volet.inverseCommande })
                    time.sleep(1)
                
                    if SHOW_DEBUG:
                        Constellation.WriteInfo(ret)
                        time.sleep(1)
        # Fin while
    except: 
        Constellation.WriteInfo("crash")
        


# Démarrage application.
Constellation.Start(OnStart);